package gov.va.vinci.dart.json.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.json.GroupListView;
import gov.va.vinci.dart.json.GroupView;
import gov.va.vinci.dart.json.RoleListView;
import gov.va.vinci.dart.json.RoleView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestRoleListViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		Role.initialize();
	}

	@Test
	public void testOne() throws Exception {
		RoleListViewBuilder builder = new RoleListViewBuilder();
		
		try {
			builder.build((Collection<Role>)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		List<Role> roleList = new ArrayList<Role>();
		
		RoleListView rlv = builder.build(roleList);
		Assert.assertNotNull(rlv);
		Assert.assertNotNull(rlv.getRoles());
		Assert.assertEquals(rlv.getRoles().size(), 0);
		
		Role role = DartObjectFactory.getInstance().getRoleDAO().findById(1);
		
		roleList.add(role);
		
		rlv = builder.build(roleList);
		Assert.assertNotNull(rlv);
		Assert.assertNotNull(rlv.getRoles());
		Assert.assertEquals(rlv.getRoles().size(), 1);
		
		RoleView rv = rlv.getRoles().get(0);
		Assert.assertNotNull(rv);
		Assert.assertEquals(rv.getId(), 1);
		Assert.assertEquals(rv.getName(), role.getName());
	}
	
}
